--> Pralable
/*
IF EXISTS(SELECT NULL FROM sys.databases WHERE name = 'DB_CRYPT')
BEGIN
   EXEC ('USE DB_CRYPT;
          ALTER DATABASE DB_CRYPT SET SINGLE_USER WITH ROLLBACK IMMEDIATE;
          USE master;
          DROP DATABASE DB_CRYPT;');
END;

IF EXISTS(SELECT * FROM sys.server_principals WHERE name = 'CNX_FRED')
   EXEC ('DROP LOGIN CNX_FRED;');

*/
-- USE master;

-- On cre une nouvelle base de donnes
CREATE DATABASE DB_CRYPT
GO

-- On se place dans le contexte de cette nouvelle base
USE DB_CRYPT
GO

-- On cre une table pour stocker des messages lectroniques
CREATE TABLE dbo.T_POST_PST
(PST_ID          BIGINT IDENTITY PRIMARY KEY,
 PST_DATEHEURE   DATETIME2(0) NOT NULL DEFAULT GETUTCDATE(), --> ATTENTION : DATETIME2(0) n'existe pas sous SQL Server 2005. Le remplacer par DATETIME
 PST_MAIL        NVARCHAR(256) NOT NULL,
 PST_TITRE       NVARCHAR(124),
 PST_CORPS       NVARCHAR(max),
 PST_SIGNATURE   VARBINARY(256));
GO

-- On cre un compte de connexion pour les messages de Fred
CREATE LOGIN CNX_FRED 
   WITH PASSWORD = 'PassFred',
        DEFAULT_DATABASE = DB_CRYPT;
GO

-- On cre un utilisateur reli au compte de connexion de Fred
CREATE USER USR_FRED 
   FROM LOGIN CNX_FRED;
GO

-- On cre un certificat, proprit de Fred, afin de signer les donnes
CREATE CERTIFICATE CRT_SIGN_FRED
   AUTHORIZATION USR_FRED
   ENCRYPTION BY PASSWORD = N'O.S.S. CENT dix-sept '
   WITH SUBJECT = N'Signature des messages de Fred',
        EXPIRY_DATE = '20201231';
GO

-- On interdit lutilisation du certificat par tous, except Fred qui en est le propritaire
REVOKE CONTROL ON CERTIFICATE::CRT_SIGN_FRED TO PUBLIC;
GO

-- On autorise Fred  lire, insrer et modifier des donnes de la table
GRANT SELECT, INSERT, UPDATE ON dbo.T_POST_PST TO USR_FRED;
GO

-- On cre une procdure pour insrer des donnes signes
CREATE PROCEDURE dbo.P_I_PST @PST_MAIL NVARCHAR(256),
                             @PST_TITRE NVARCHAR(124), 
							 @PST_CORPS NVARCHAR(max),
                             @PASSWORD NVARCHAR(256)
AS
SET NOCOUNT ON;
BEGIN
DECLARE @CRT_NAME sysname, @PST_SIGNATURE VARBINARY(256);
IF USER LIKE 'USR?__%' ESCAPE '?'
BEGIN
   SET @CRT_NAME = 'CRT_SIGN_' + SUBSTRING(USER, 5, LEN(USER) - 4)
   SET @PST_SIGNATURE = SIGNBYCERT(CERT_ID(@CRT_NAME), LEFT(@PST_MAIL + @PST_TITRE + @PST_CORPS, 500), @PASSWORD);
END
INSERT INTO dbo.T_POST_PST (PST_MAIL, PST_TITRE, PST_CORPS, PST_SIGNATURE)
VALUES (@PST_MAIL, @PST_TITRE, @PST_CORPS, @PST_SIGNATURE);
END
GO

-- On autorise Fred  excuter la procdure
GRANT EXECUTE ON dbo.P_I_PST TO PUBLIC;
GO

-- On lance la procdure sous lutilisateur gnrique (dbo)
EXEC dbo.P_I_PST @PST_MAIL = N'fred@sqlpro.com',
                 @PST_TITRE = N'SQL Server finger in the nose !',
                 @PST_CORPS = N'Bien plus simple qu''il n''y parat',
                 @PASSWORD = N'O.S.S. CENT dix-sept ';
GO

-- On se fait passer pour Fred
EXECUTE AS USER = 'USR_FRED';
GO

-- On lance la procdure sous lutilisateur Fred
EXEC dbo.P_I_PST @PST_MAIL = N'fred@sqlpro.com',
                 @PST_TITRE = N'SQL Server finger in the nose !',
                 @PST_CORPS = N'Bien plus simple qu''il n''y parat',
                 @PASSWORD = N'O.S.S. CENT dix-sept ';
GO

-- On retourne  lutilisateur gnrique dbo
REVERT;

-- On vrifie les donnes signes avec le certificat de Fred
SELECT PST_ID, PST_DATEHEURE, PST_MAIL, PST_SIGNATURE,
       VERIFYSIGNEDBYCERT(CERT_ID('CRT_SIGN_FRED'), LEFT(PST_MAIL + PST_TITRE + PST_CORPS, 500), PST_SIGNATURE) AS SIGNATURE_OK
FROM dbo.T_POST_PST;